'********************************************************
'* CCM PROTOCAL DEMO                                    *
'* INPUT MONITOR  "64 POINT "      MASTER/SLAVE NO=1    *
'* FUNCTION 32 READ MODE                                *
'********************************************************
BEGIN:
        WIDTH 80, 25: CLS : COLOR 6
        LOCATE 1, 1: PRINT "I/O STATUS DISPLAY.": COLOR 6: PRINT
        LOCATE 2, 1: PRINT "000-1777(I0000-I1777)": COLOR 7: PRINT
'* INPUT THE MONITOR No. OF INPUT POINT (OCT)
'* CHANGE THE OCT NUMBER TO DECIMAL
        INPUT "IN BYTE NO: ", TCN: NO = 0
        IF TCN < 100 THEN NO = (TCN \ 10) * 8 + (TCN MOD 10) + 257
        IF TCN >= 100 AND TCN < 200 THEN NO = (TCN \ 10) * 8 + (TCN MOD 10) + 241
        IF TCN > 177 THEN GOTO BEGIN
        GOSUB HEADER                    'GOTO HEADER SUBROUTINE
        GOSUB IODISP                    'GOTO I/O NO.DISPLAY ROUTINE
'
'******************************************************************
'
INIT:
        CLOSE
'******************************************************************
'  PORT COM2; 9600BPS; NO PARITY; 8BIT; 1 STOP BIT
'******************************************************************
        OPEN "COM2:9600,N,8,1" FOR RANDOM AS #1
        A$ = "N" + CHR$(&H21) + CHR$(&H5)
        PRINT #1, A$                    'CALL SAVE
        B$ = INPUT$(3, #1)              'WAIT ACK FROM SLAVE
        PRINT #1, HD$                   'SEND HEADER
        INPUT #1, C$                    'WAIT ACK OF HEADER
        D$ = INPUT$(23, #1)             'RECIEVE DATA
        A$ = CHR$(&H6)
        PRINT #1, A$                    'SEND ACK
        INPUT #1, E$                    'RECIEVE EOT
        E$ = CHR$(&H4)
        PRINT #1, E$                    'SEND EOT
        LOCATE 20, 5
'
'******************************************************************
'
'DISPLAY1
'
        I = 4: J = 8: GOTO DISP1
DISP3:
        I = I + 2: J = J + 3: IF J = 20 THEN GOTO WAITKEY
DISP1:
        C$ = LEFT$(D$, I): D$(1) = RIGHT$(C$, 1)
        C1$ = LEFT$(D$, I + 1): D$(2) = RIGHT$(C1$, 1)
        N = 2: X = 2
DISP1A:
        LOCATE J, X
        GOSUB DISPLAY
        IF N = 2 THEN N = 1 ELSE IF N = 1 THEN GOTO DISP2
        X = X + 16: GOTO DISP1A

'DISPLAY2
'
DISP2:
        I = I + 2
        C$ = LEFT$(D$, I): D$(1) = RIGHT$(C$, 1)
        C1$ = LEFT$(D$, I + 1): D$(2) = RIGHT$(C1$, 1)
        N = 2: X = X + 16
DISP2A:
        LOCATE J, X
        GOSUB DISPLAY
        IF N = 2 THEN N = 1 ELSE IF N = 1 THEN GOTO DISP3
        X = X + 16: GOTO DISP2A

'
'******************************************************************
'
WAITKEY:  
        ON KEY(1) GOSUB PSTOP: KEY(1) ON
        LOCATE 5, 18: PRINT "PRESS F.1 KEY TO STOP": GOTO INIT
PRTMES:    
        COLOR 6: LOCATE 5, 20: INPUT " DO YOU WANT REPEAT (Y/N)"; K$: COLOR 7
        IF K$ = "Y" THEN GOTO BEGIN
        CLS 2: END
'
'******************************************************************
'
'SUBROUTINE
'MAKE HEADER
HEADER:
        UT$ = CHR$(&H30) + CHR$(&H31)           'UNIT NO (01)
        SH$ = CHR$(&H1)                         'SOH (START OF HEADER)
        RW$ = CHR$(&H30)                        'READ/WRITE
        FC$ = CHR$(&H32)                        'FUNCTION
        AD$ = HEX$(NO): ADL = LEN(AD$)          'HEAD ADDRESS
        BT1 = 0: BT2 = 16
        IF ADL = 1 THEN AD$ = CHR$(&H30) + CHR$(&H30) + CHR$(&H30) + AD$
        IF ADL = 2 THEN AD$ = CHR$(&H30) + CHR$(&H30) + AD$
        IF ADL = 3 THEN AD$ = CHR$(&H30) + AD$
        BT1$ = HEX$(BT1): BT1L = LEN(BT1$)
        IF BT1L = 1 THEN BT1$ = CHR$(&H30) + BT1$
        BT2$ = HEX$(BT2): BT2L = LEN(BT2$)
        IF BT2L = 1 THEN BT2$ = CHR$(&H30) + BT2$
        BT$ = BT1$ + BT2$                          'BYTE
        MT$ = CHR$(&H30) + CHR$(&H30)              'MASTER NO
        ETB$ = CHR$(&H17)                          'ETB(END OF BLOCK)
        LRC$ = UT$ + RW$ + FC$ + AD$ + BT$ + MT$
        GOSUB LRCAL
        HD$ = SH$ + UT$ + RW$ + FC$ + AD$ + BT$ + MT$ + ETB$ + LRC$
        RETURN
'**************************************************************************
'LRC CALCULATION
LRCAL:
        LRC = ASC(LEFT$(LRC$, 1)): CT = LEN(LRC$)
        FOR I = 1 TO CT - 1
                LRC = LRC XOR ASC(MID$(LRC$, I + 1, 1))
        NEXT
        LRC$ = HEX$(LRC): LRCL = LEN(LRC$)
        IF LRCL = 1 THEN LRC$ = CHR$(&H30) + LRC$
        RETURN
'**************************************************************************
DISPLAY:
        E1$ = "OFF ": E2$ = "OFF ": E3$ = "OFF ": E4$ = "OFF "
        E% = VAL("&H" + D$(N))
        IF INT(E% / 8) THEN E% = E% MOD 8: E1$ = " ON "
        IF INT(E% / 4) THEN E% = E% MOD 4: E2$ = " ON "
        IF INT(E% / 2) THEN E% = E% MOD 2: E3$ = " ON "
        IF E% THEN E4$ = " ON "
        PRINT E4$; E3$; E2$; E1$
        RETURN
'**************************************************************************
PSTOP:
        CLS : RETURN PRTMES
'**************************************************************************
' I/O NO. DISPLAY
IODISP:
        TCN = TCN * 10: LT = 7
        FOR X = 0 TO 60 STEP 20
           LOCATE LT, 1
           FOR I = X TO X + 7
                TCNO = TCN + I: IF TCNO = 80 THEN TCN = 100 - X
                TCNO = TCN + I: IF TCNO = 180 THEN TCN = 200 - X
                TCNO = TCN + I: IF TCNO = 280 THEN TCN = 300 - X
                TCNO = TCN + I: IF TCNO = 380 THEN TCN = 400 - X
                TCNO = TCN + I: IF TCNO = 480 THEN TCN = 500 - X
                TCNO = TCN + I: IF TCNO = 580 THEN TCN = 600 - X
                TCNO = TCN + I: IF TCNO = 680 THEN TCN = 700 - X
                TCNO = TCN + I: IF TCNO = 780 THEN TCN = 1000 - X
                TCNO = TCN + I: IF TCNO = 1080 THEN TCN = 1100 - X
                TCNO = TCN + I: IF TCNO = 1180 THEN TCN = 1200 - X
                TCNO = TCN + I: IF TCNO = 1280 THEN TCN = 1300 - X
                TCNO = TCN + I: IF TCNO = 1380 THEN TCN = 1400 - X
                TCNO = TCN + I: IF TCNO = 1480 THEN TCN = 1500 - X
                TCNO = TCN + I: IF TCNO = 1580 THEN TCN = 1600 - X
                TCNO = TCN + I: IF TCNO = 1680 THEN TCN = 1700 - X
                TCNO = TCN + I: IF TCNO = 1780 THEN RETURN
                PRINT USING "####"; TCN + I;
          NEXT I

          FOR I = X + 10 TO X + 17
                TCNO = TCN + I: IF TCNO = 80 THEN TCN = 90 - X
                TCNO = TCN + I: IF TCNO = 180 THEN TCN = 190 - X
                TCNO = TCN + I: IF TCNO = 280 THEN TCN = 290 - X
                TCNO = TCN + I: IF TCNO = 380 THEN TCN = 390 - X
                TCNO = TCN + I: IF TCNO = 480 THEN TCN = 490 - X
                TCNO = TCN + I: IF TCNO = 580 THEN TCN = 590 - X
                TCNO = TCN + I: IF TCNO = 680 THEN TCN = 690 - X
                TCNO = TCN + I: IF TCNO = 780 THEN TCN = 790 - X
                TCNO = TCN + I: IF TCNO = 1080 THEN TCN = 1090 - X
                TCNO = TCN + I: IF TCNO = 1180 THEN TCN = 1190 - X
                TCNO = TCN + I: IF TCNO = 1280 THEN TCN = 1290 - X
                TCNO = TCN + I: IF TCNO = 1380 THEN TCN = 1390 - X
                TCNO = TCN + I: IF TCNO = 1480 THEN TCN = 1490 - X
                TCNO = TCN + I: IF TCNO = 1580 THEN TCN = 1590 - X
                TCNO = TCN + I: IF TCNO = 1680 THEN TCN = 1690 - X
                TCNO = TCN + I: IF TCNO = 1780 THEN RETURN

                PRINT USING "####"; TCN + I;
           NEXT I: LT = LT + 3
        NEXT
        RETURN







